// no fog version of colorGen.inc

uniform	vec4	u_gen;
uniform	vec4	u_parm0;
uniform	vec4	u_parm1;
uniform	vec4	u_parm2;
uniform	vec4	u_parma;

#define	GLSL_CGEN_CONST				0.0
#define	GLSL_CGEN_LIGHTING_DIFFUSE		1.0
#define	GLSL_CGEN_VERTEX			2.0
#define	GLSL_CGEN_ONE_MINUS_VERTEX		3.0
#define	GLSL_CGEN_VERTEX_ALPHA			4.0
#define	GLSL_CGEN_ONE_MINUS_VERTEX_ALPHA	5.0

#define	GLSL_AGEN_CONST				0.0
#define	GLSL_AGEN_LIGHTING_SPECULAR		1.0
#define	GLSL_AGEN_VERTEX			2.0
#define	GLSL_AGEN_ONE_MINUS_VERTEX		3.0
#define	GLSL_AGEN_VERTEX_COLOR			4.0
#define	GLSL_AGEN_ONE_MINUS_VERTEX_COLOR	5.0
#define	GLSL_AGEN_PORTAL			6.0

vec4 colorGen (vec4 glVertex)
{
	vec4	col;

//if (u_gen.x == GLSL_CGEN_CONST)	// default
	col = u_parm0;	// shut up compiler :(
	if (u_gen.x == GLSL_CGEN_LIGHTING_DIFFUSE)
	{	// u_parm0.xyz = lightDir
		// u_parm1 = ambientLight
		// u_parm2 = directedLight
		float incoming = dot(gl_Normal, u_parm0.xyz);
		col = u_parm1 + max(incoming, 0.0) * u_parm2;
	}
	if (u_gen.x == GLSL_CGEN_VERTEX)
		col = gl_Color;
	if (u_gen.x == GLSL_CGEN_ONE_MINUS_VERTEX)
		col = 1.0 - gl_Color;
	if (u_gen.x == GLSL_CGEN_VERTEX_ALPHA)
		col = vec4(gl_Color.a);
	if (u_gen.x == GLSL_CGEN_ONE_MINUS_VERTEX_ALPHA)
		col = 1.0 - vec4(gl_Color.a);

	if (u_gen.y >= GLSL_AGEN_CONST)
	{
		if (u_gen.y == GLSL_AGEN_CONST)
			col.a = u_parm0.a;
		if (u_gen.y == GLSL_AGEN_LIGHTING_SPECULAR)
		{	// u_parma.xyz = backEnd.or.viewOrigin
			vec3 lightDir = normalize(vec3(-960.0, 1980.0, 96.0) - glVertex.xyz);
			float d = dot(gl_Normal, lightDir);
			vec3 reflected = gl_Normal * 2.0 * d - lightDir;
			vec3 viewer = u_parma.xyz - glVertex.xyz;
			float ilength = inversesqrt(dot(viewer, viewer));
			float l = max(dot(reflected, viewer) * ilength, 0.0);
			col.a = l*l*l*l;
		}
		if (u_gen.y == GLSL_AGEN_VERTEX)
			col.a = gl_Color.a;
		if (u_gen.y == GLSL_AGEN_ONE_MINUS_VERTEX)
			col.a = 1.0 - gl_Color.a;
		if (u_gen.y == GLSL_AGEN_VERTEX_COLOR)
			col.a = (gl_Color.r + gl_Color.g + gl_Color.b) * 0.33333;
		if (u_gen.y == GLSL_AGEN_ONE_MINUS_VERTEX_COLOR)
			col.a = 1.0 - (gl_Color.r + gl_Color.g + gl_Color.b) * 0.33333;
		if (u_gen.y == GLSL_AGEN_PORTAL)
		{	// u_parma.xyz = backEnd.viewParms.or.origin
			// u_parma.w = 1.0 / tess.shader->portalRange
			col.a = length(glVertex.xyz - u_parma.xyz) * u_parma.w;
		}
	}

	return col;
}
